**********************************************************************************
*
* 
* 'reg_event_DD_FTA.do'
* (formerly known as 'coef_plots.do')
*
* PREPARE COEFFICIENT PLTS FOR VARIABLES OF INTEREST AFTER TRADE DEAL
* 
*
* Created       on October  16th  2020
* Last modified on December 23rd 2020
*
*
**********************************************************************************


**********************************************************************************
set more off
cap prog drop _all

program define winsor
sum `1', d
gen win_`1' = `1'
replace win_`1'=r(p1) if `1'<r(p1) & `1'!=.
replace win_`1'=r(p99) if `1'>r(p99) &`1'!=. 
end

program define winsor2
	sum `1', d
	gen win2_`1' = 0
	replace win2_`1' = 1 if `1'>r(p1) & `1'<r(p99) & `1'!=.
end
**********************************************************************************


**********************************************************************************
use "../task_LR/output/LRbetas_daily_trade.dta", replace

	*Adding GDP
	cap drop _merge
	sort ISOPAIR year
	merge 1:1 ISOPAIR year using "../task_data/output/gravity.dta"
	drop if _merge == 2
	drop _merge
**********************************************************************************


**********************************************************************************
	* Defining panel
	set more off
	cap egen id = group(ISOPAIR)
	xtset id year

	egen iso_1_t = group(base year)
	egen iso_2_t = group(foreign year)

	* Defining trade variables
	cap drop log_trade log_trade_gdp log_export log_import
	gen log_trade = log(trade_gross)
	gen log_export = log(export)
	gen log_import = log(import)

	gen trade_share = (  trade_gross / gdp_o )*100
	gen key_partner = 0
	replace key_partner = 1 if trade_share > 1

	replace fx_vol = fx_vol*sqrt(252)
	
	*Defining EIA variables 
	sort id year

	gen CUMECU = 0
	replace CUMECU = 1 if EIA == 4 | EIA == 5 | EIA == 6
	gen FTA = 0
	replace FTA = 1 if EIA == 3 
	gen TWPTA = 0
	replace TWPTA = 1 if EIA == 2
	gen OWPTA = 0 
	replace OWPTA = 1 if EIA == 1
	gen PTA = 0 
	replace PTA = 1 if EIA == 1 | EIA == 2


	cap drop emerging
	gen emerging = 0
	replace emerging = 1 if ///
		base == "BRL" | base == "CLP" | base == "CNY" | base == "COP" | base == "CZK" | base == "EGP" | /// 
		base == "GRD" | base == "HUF" | base == "INR" | base == "IDR" | base == "KRW" | base == "MYR" | ///
		base == "MXN" | base == "PEN" | base == "PHP" | base == "PLN" | base == "QAR" | base == "RUB" | ///
		base == "ZAR" | base == "THB" | base == "TWD" | base == "TRY" | base == "AED" 
**********************************************************************************	

**********************************************************************************
** Focusing on bilateral deals **
bys ISOPAIR: egen bil_OWPTA = sum(deal_change_OWPTA_un)
bys ISOPAIR: egen bil_TWPTA = sum(deal_change_TWPTA_un)
bys ISOPAIR: egen bil_FTA = sum(deal_change_FTA_un)
bys ISOPAIR: egen bil_CUCMECU = sum(deal_change_CUCMECU_un)

gen OWPTA_un = 0
replace OWPTA_un = OWPTA if bil_OWPTA >= 1
gen TWPTA_un = 0
replace TWPTA_un = TWPTA if bil_TWPTA >= 1
gen PTA_un = 0
replace PTA_un = PTA if bil_TWPTA >= 1 | bil_TWPTA >= 1
gen FTA_un = 0
replace FTA_un = FTA if bil_FTA >= 1
gen CUMECU_un = 0
replace CUMECU_un = CUMECU if bil_CUCMECU >= 1

sort id year 
**********************************************************************************

**********************************************************************************
** Focusing on multilateral deals **

gen OWPTA_mult = 0
replace OWPTA_mult = OWPTA - OWPTA_un
gen TWPTA_mult = 0
replace TWPTA_mult = TWPTA - TWPTA_un
gen FTA_mult = 0
replace FTA_mult = FTA - FTA_un
gen CUMECU_mult = 0
replace CUMECU_mult = CUMECU - CUMECU_un
gen PTA_mult = 0
replace PTA_mult = PTA - PTA_un

sort id year 
**********************************************************************************


** This will loop over all types of trade deals, pooled or bilateral
local eia_type PTA FTA CUMECU PTA_mult FTA_mult CUMECU_mult PTA_un FTA_un CUMECU_un


	foreach eia in `eia_type' {

	**********************************************************************************
		label var log_import "Log Imports"
		
		label var distw "Distance"
		label var contig "Common border"
		label var comlang_off "Common language"
		label var comcol "Colonial Link"
		label var comleg_pretrans "Shared Legal"

		***** EVENT STUDY: OWPTA/TWPTA/CUMECU/FTA *******
			cap drop experiment
			gen experiment = `eia'
			cap drop treat
			bys ISOPAIR: egen treat = max(experiment)

			cap drop change
			sort id year
			gen change = 0
			bys id: replace change = 1 if experiment > l.experiment 
			cap drop change_id
			bys id: egen change_id = max(change)

			* Identifying year of change:
			cap drop event_date
			gen aux = year if change == 1
			bys id: egen event_date = mean(aux)
			drop aux	
		*******************************	
		
		cap drop diff
		gen diff = year - event_date

		set more off
		cap drop f_* l_*
		forvalues i = 1/55 {
			gen f_`i' = 0
			replace f_`i' = 1 if diff == `i'
			label variable f_`i' "`i'"
			
			gen l_`i' = 0
			replace l_`i' = 1 if diff == -`i'
			label variable l_`i' "-`i'"
		}
	**********************************************************************************

	**********************************************************************************
	***** WINSORIZE!! 
	cap drop win_log_import win_beta win_R2_y win_fx_vol win_var_adj
	winsor log_import
	winsor beta
	winsor R2_y
	winsor fx_vol
	winsor var_adj

	cap drop win2_log_import win2_beta win2_R2_y win2_fx_vol win2_var_adj
	winsor2 log_import
	winsor2 beta
	winsor2 R2_y
	winsor2 fx_vol
	winsor2 var_adj
	**********************************************************************************

	**********************************************************************************
		/* 
		## IMPORTANT: Year of change (D0) is the reference (constant) in the regressions ## 
		gen f_0 = 0
		replace f_0 = 1 if diff == 0
		label variable f_0 "0"  
		*/
		
		local varlist log_import R2_y beta fx_vol var_adj win_log_import

		eststo clear
		foreach var in `varlist' {

			cap drop dep_var 
			gen dep_var = `var'
			cap drop d5_dep_var
			gen d5_dep_var = dep_var - l5.dep_var
			
			display dep_var

			eststo: reghdfe dep_var ///
			l_55 l_54 l_53 l_52 l_51 ///
			l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
			l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
			l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
			l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
			l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
			f_* ///
			change_id ///
			distw contig comlang_off comcol comleg_pretrans ///
			, absorb(iso_1_t iso_2_t) cluster(id) resid

			coefplot, drop(l_55 l_54 l_53 l_52 l_51 ///
						   l_21 l_22 l_23 l_24 l_25 ///
						   l_26 l_27 l_28 l_29 l_30 ///
						   l_31 l_32 l_33 l_34 l_35 ///
						   l_36 l_37 l_38 l_39 l_40 ///
						   l_41 l_42 l_43 l_44 l_45 ///
						   l_46 l_47 l_48 l_49 l_50 ///
						   f_21 f_22 f_23 f_24 f_25 ///
						   f_26 f_27 f_28 f_29 f_30 ///
						   f_31 f_32 f_33 f_34 f_35 ///
						   f_36 f_37 f_38 f_39 f_40 ///
						   f_41 f_42 f_43 f_44 f_45 ///
						   f_46 f_47 f_48 f_49 f_50 ///
						   f_51 f_52 f_53 f_54 f_55 ///
						   change_id ///
						   distw contig comlang_off comcol comleg_pretrans _cons) ///
						   vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
			xlabel(,labsize(vsmall)) 

			* Exporting regression results to txt *
			local outputr = "./output/coef_for_plots/coef_for_plot_postest_gravity_"+"`eia'"+"_"+"`var'"+".txt" 
			outreg2 using `outputr', drop(distw contig comlang_off comcol comleg_pretrans) ///
			replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
		}
					
		* Exporting regression results to tex table *
		*local output = "./output/tables/DiD_table_gravity_"+"`eia'"+".tex"
		*esttab using `output', compress ///
		*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
		*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )
	**********************************************************************************


	**********************************************************************************
	** RUN THE BILATERAL PAIR FIXED EFFECT REGRESSION
	eststo clear

	local varlist log_import R2_y beta fx_vol var_adj win_log_import
		foreach var in `varlist' {
			cap drop dep_var 
			gen dep_var = `var'
			cap drop d5_dep_var
			gen d5_dep_var = dep_var - l5.dep_var
			*** Regression with country-pair FE instead of gravity:
			display dep_var
			eststo: reghdfe ///
			dep_var ///
			l_55 l_54 l_53 l_52 l_51 ///
			l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
			l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
			l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
			l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
			l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
			f_* /// 
			distw contig comlang_off comcol comleg_pretrans, ///
			absorb(iso_1_t iso_2_t id) cluster(id) resid
		
			coefplot, drop(l_55 l_54 l_53 l_52 l_51 ///
						   l_21 l_22 l_23 l_24 l_25 ///
						   l_26 l_27 l_28 l_29 l_30 ///
						   l_31 l_32 l_33 l_34 l_35 ///
						   l_36 l_37 l_38 l_39 l_40 ///
						   l_41 l_42 l_43 l_44 l_45 ///
						   l_46 l_47 l_48 l_49 l_50 ///
						   f_21 f_22 f_23 f_24 f_25 ///
						   f_26 f_27 f_28 f_29 f_30 ///
						   f_31 f_32 f_33 f_34 f_35 ///
						   f_36 f_37 f_38 f_39 f_40 ///
						   f_41 f_42 f_43 f_44 f_45 ///
						   f_46 f_47 f_48 f_49 f_50 ///
						   f_51 f_52 f_53 f_54 f_55 ///
						   change_id ///
						   distw contig comlang_off comcol comleg_pretrans _cons) ///
						   vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
			xlabel(,labsize(vsmall)) 		
			*recast(line) lwidth(*2) ciopts(recast(rline) lpattern(dash)) 
			
			*local output = "./output/figures/plot_coef_"+"`eia'"+"_"+"`var'"+".pdf"
			*graph export `output', replace

			* Exporting regression results to txt *
			local outputr = "./output/coef_for_plots/coef_for_plot_postest_fe_"+"`eia'"+"_"+"`var'"+".txt"
			outreg2 using `outputr', drop(change_id distw contig comlang_off comcol comleg_pretrans) ///
			replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
		}


	********************************************************************
	* Exporting regression results to tex table *
	*local output = "./output/tables/DiD_table_"+"`eia'"+"_FE.tex"
	*esttab using `output', compress ///
	*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
	*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )		
	********************************************************************
}
